//
//  $Id: AHKABArrayController.m 98 2009-06-12 17:01:44Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABArrayController.h"
#import "AHKABMainWindowController.h"


@implementation AHKABArrayController

#pragma mark override methods

// --- Since the nib file instanciates this ArrayController by invoking initWithCoder:, 
// --- we should write initialization process in this method, not -init.
- (id)initWithCoder:(NSCoder *)coder
{
	self = [super initWithCoder:coder];
	if (self != nil)
	{
		oldSearchString = [[NSString alloc] init];
	}
	return self;
}

- (void)dealloc
{
	[oldSearchString release];
	[super dealloc];
}

- (void)awakeFromNib
{
	if ([[self superclass] instancesRespondToSelector:@selector(awakeFromNib)])
	{
		[super awakeFromNib];
	}
	
	[searchField setDelegate:self];
	
	// register for drag and drop
	//	[self registerTableViewForDraggingType];
	
	NSUndoManager *undoManager = [searchField undoManager];
	[undoManager disableUndoRegistration];
	[self setSearchFilterTag:AHKABSearchAll];
	[undoManager enableUndoRegistration];
	
}

//- (void)insertObjects:(NSArray *)objects atArrangedObjectIndexes:(NSIndexSet *)indexes
//{
//	[self storeSelectedObjects:[self selectedObjects]];
//	[super insertObjects:objects atArrangedObjectIndexes:indexes];
//	[self storeSelectedObjects:[self selectedObjects]];
//}
//
//- (void)removeObjectsAtArrangedObjectIndexes:(NSIndexSet *)indexes
//{
//	NSLog(@"removeObjects... called");
//	[self storeSelectedObjects:[self selectedObjects]];
//	
//	[super removeObjectsAtArrangedObjectIndexes:indexes];
//	
//	[self storeSelectedObjects:[self selectedObjects]];
//}

//- (void)insertObject:(id)object atArrangedObjectIndex:(unsigned int)index
//{
//	unsigned toIndex;
//	if (index < [[self arrangedObjects] count])
//	{
//		toIndex = [[self content] indexOfObject:[[self arrangedObjects] objectAtIndex:index]];
//	}
//	else
//	{
//		id toObject = [[self arrangedObjects] lastObject];
//		if(toObject == nil)
//		{
//			toIndex = 0;
//		}
//		else
//		{
//			toIndex = [[self content] indexOfObject:toObject] + 1;
//		}
//	}
//	[mainWindowController insertObject:object inPeopleAtIndex:toIndex];
//	[self rearrangeObjects];
//}


// --- return arranged (i.e., filtered or sorted) array
- (NSArray *)arrangeObjects:(NSArray *)objects
{
	NSString *searchString = [self searchString];
	if (searchString == nil || [searchString isEqualToString:@""])
	{
		return [super arrangeObjects:objects];
	}
	
	NSMutableArray *matchedObjects = [NSMutableArray arrayWithCapacity:[objects count]];
	
	NSArray      *searchKeys       = [self searchFilterKeys];
	
	NSEnumerator *peopleEnumerator = [objects objectEnumerator];
	id           person;
	
	while (person = [peopleEnumerator nextObject])
	{
		NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
		
		// if the item has just been created, add it unconditionally
		//if (person == newObj)
		//{
		//	[matchedObjects addObject:item];
		//	newObj = nil;
		//}
		//else
		//{
		NSEnumerator *keysEnumerator = [searchKeys objectEnumerator];
		NSString     *key;
		
		while (key = [keysEnumerator nextObject])
		{
			NSString *valueOfCurrentKey = [person valueForKeyPath:key];
			if (valueOfCurrentKey && [valueOfCurrentKey rangeOfString:searchString options:NSCaseInsensitiveSearch].location != NSNotFound)
			{
				[matchedObjects addObject:person];
				break;
			}
		}
		[pool release];
	}
	return [super arrangeObjects:matchedObjects];
}

#pragma mark methods for search
- (IBAction)search:(id)sender
{
	[self rearrangeObjects];
	//	[self setSearchString:[searchField stringValue]];
}

- (NSString *)searchString
{
	return [searchField stringValue];
}

- (void)setSearchString:(NSString *)value
{
	//	[searchField setStringValue:value];
	//	[self rearrangeObjects];
	
	if (value == nil) value = [NSString string];
	
	if ([oldSearchString isEqualToString:value] == NO)
	{
		NSUndoManager *undoManager = [searchField undoManager];
		[[undoManager prepareWithInvocationTarget:self] setSearchString:oldSearchString];
		if ([undoManager isUndoing] == NO && [undoManager isRedoing] == NO)
		{
			[undoManager setActionName:NSLocalizedStringFromTable(@"Change Search Word", @"AHKABLocalizable", @"undo.searchWord")];
		}
		[oldSearchString autorelease];
		oldSearchString = [value copy];
		
		if ([[searchField stringValue] isEqualToString:value] == NO)
		{
			[searchField setStringValue:value];
		}
		[self rearrangeObjects];
	}
}

// --- delegate method of NSControl (searchField)
// --- Invoke setSearchString: in order to register a search word into the undo manager
- (void)controlTextDidEndEditing:(NSNotification *)aNotification
{
	if ([aNotification object] == searchField)
	{
		[self setSearchString:[searchField stringValue]];
	}
}

// --- 
- (IBAction)selectSearchFilters:(id)sender
{
	if ([sender conformsToProtocol:@protocol(NSMenuItem)])
	{
		[self setSearchFilterTag:[sender tag]];
	}
}

// --- accessor method for search filter
- (int)searchFilterTag
{
	return searchFilterTag;
}

// --- accessor method for search filter
- (void)setSearchFilterTag:(int)value
{
	int oldTag = [self searchFilterTag];
	
	if (value != NSNotFound && value != oldTag)
	{
		NSUndoManager *undoManager = [searchField undoManager];
		[[undoManager prepareWithInvocationTarget:self] setSearchFilterTag:oldTag];
		if ([undoManager isUndoing] == NO && [undoManager isRedoing] == NO)
		{
			[undoManager setActionName:NSLocalizedStringFromTable(@"Change Filter", @"AHKABLocalizable", @"undo.searchFilter")];
		}
		// What is the most important is 4th line, to re-set a search menu templete.
		// In the API reference of NSSearchFieldCell: "If you need to change the menu, modify the search menu template and call the setSearchMenuTemplate: method to update." 
		
		NSMenu *searchMenu = [[searchField cell] searchMenuTemplate];
		[[searchMenu itemWithTag:oldTag] setState:NSOffState];
		[[searchMenu itemWithTag:value] setState:NSOnState];
		[[searchField cell] setSearchMenuTemplate:searchMenu];
		
		searchFilterTag = value;
		NSString *newFilterString = [[[[searchField cell] searchMenuTemplate] itemWithTag:value] title];
		[[searchField cell] setPlaceholderString:newFilterString];
		
		/*
		// In Mac OS X 10.3 setting toolbar label does not work well, (when label string is changed, cell width also changes) 
		// thus following lines are commented out.
		NSArray       *toolbarItems = [[[mainWindowController window] toolbar] items];
		NSEnumerator  *enumerator   = [toolbarItems objectEnumerator];
		NSToolbarItem *toolbarItem;
		
		while (toolbarItem = [enumerator nextObject])
		{
			if ([[toolbarItem itemIdentifier] isEqualToString:AHKToolbarSearchItemIdentifier])
		{
				NSString *labelString = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Search %@", @"AHKABLocalizable", @"toolbar.searchLabel"), newFilterString];
				[toolbarItem setLabel:labelString];
				break;
			}
		}
		*/
		
		[self rearrangeObjects];
	}
}

// --- return key-paths of currently selected search filter
- (NSArray *)searchFilterKeys
{
	switch ([self searchFilterTag])
	{
		case AHKABSearchAll:
			return [NSArray arrayWithObjects:@"name", @"phoneticName", @"phones.firstValue", @"phones.secondValue", @"phones.thirdValue", @"emails.firstValue", @"emails.secondValue", @"emails.thirdValue", @"addressValue", @"hobby", @"url", @"note", nil];
		case AHKABSearchNameAndPhoneticName:
			return [NSArray arrayWithObjects:@"name", @"phoneticName", nil];
		case AHKABSearchEveryPhoneNumber:
			return [NSArray arrayWithObjects:@"phones.firstValue", @"phones.secondValue", @"phones.thirdValue",	nil];
		case AHKABSearchEveryEmailAddress:
			return [NSArray arrayWithObjects:@"emails.firstValue", @"emails.secondValue", @"emails.thirdValue", nil];
		case AHKABSearchAddress:
			return [NSArray arrayWithObject:@"addressValue"];
		case AHKABSearchHobby:
			return [NSArray arrayWithObject:@"hobby"];
		case AHKABSearchURL:
			return [NSArray arrayWithObject:@"url"];
		case AHKABSearchNote:
			return [NSArray arrayWithObject:@"note"];
		default:
			return [NSArray array];
	}
}

//#pragma mark NSMenuValidation imformal protocol
//- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
//{
//	if ([menuItem action] == @selector(selectSearchFilters:))
//	{
//		if ([menuItem tag] == searchFilterTag)
//		{
//			[menuItem setState:NSOnState];
//		}
//		else
//		{
//			[menuItem setState:NSOffState];
//		}
//	}
//	// NSObjectController implements this method
//	return [super validateMenuItem:menuItem];
//}

#pragma mark other auxiliary methods
- (void)storeSelectedObjects:(NSArray *)objects
{
	NSUndoManager *undoManager = [[mainWindowController window] undoManager];
	[[undoManager prepareWithInvocationTarget:self] storeSelectedObjects:objects];
	[self setSelectedObjects:objects];
}

- (void)restoreArrangementAndSelection
{
	NSUndoManager *undoManager = [[mainWindowController window] undoManager];
	[[undoManager prepareWithInvocationTarget:self] restoreArrangementAndSelection];
	[self setSelectionIndexes:[self selectionIndexes]];
	[undoManager setActionName:NSLocalizedStringFromTable(@"Move", @"AHKABLocalizable", @"undo.move")];
}

@end
